/* @(#) somx/direntry.c 2.3 1/20/94 09:33:46 [5/15/94 17:57:56] */

/*
 * 96F8647, 96F8648, 96F8850 (C) Copyright IBM Corp. 1992, 1994
 * All Rights Reserved
 * Licensed Materials - Property of IBM
 *
 * DISCLAIMER OF WARRANTIES.
 * The following [enclosed] code is sample code created by IBM
 * Corporation. This sample code is not part of any standard or IBM
 * product and is provided to you solely for the purpose of assisting
 * you in the development of your applications.  The code is provided
 * "AS IS". IBM MAKES NO WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT
 * NOT LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE, REGARDING THE FUNCTION OR PERFORMANCE OF
 * THIS CODE.  IBM shall not be liable for any damages arising out of
 * your use of the sample code, even if they have been advised of the
 * possibility of such damages.
 *
 * DISTRIBUTION.
 * This sample code can be freely distributed, copied, altered, and
 * incorporated into other software, provided that it bears the above
 * Copyright notice and DISCLAIMER intact.
 */


#include <somp.h>
#define dirEntry_Class_Source
#include "direntry.ih"

/*
 ===============================================================================
 Operation: mkEntry
 Purpose  : Initialize new entry.
 ===============================================================================
 */

SOM_Scope void SOMLINK mkEntry(dirEntry somSelf,
                               string name, string phone_no)
{
    dirEntryData *somThis = dirEntryGetData(somSelf);
    dirEntryMethodDebug("dirEntry","mkEntry");

    _name = SOMMalloc(strlen(name)+1);
    _phone = SOMMalloc(strlen(phone_no)+1);
    strcpy (_name, name);
    strcpy (_phone, phone_no);
}

/*
 ===============================================================================
 Operation: lsEntry
 Purpose  : displays the entry on a single line.
 ===============================================================================
 */

SOM_Scope void   SOMLINK lsEntry(dirEntry somSelf)
{
    dirEntryData *somThis = dirEntryGetData(somSelf);
    dirEntryMethodDebug("dirEntry","lsEntry");

    printf ("%-16s    %-16s\n", _name, _phone);
}


/*
 ===============================================================================
 Operation: somInit
 ===============================================================================
 */


SOM_Scope void   SOMLINK somInit(dirEntry somSelf)
{
    static int firstTime = 1;

    dirEntryData *somThis = dirEntryGetData(somSelf);
    dirEntryMethodDebug("dirEntry","somInit");

    parent_somInit(somSelf);
    _name = NULL;
    _phone = NULL;

}

